-- Quartus II VHDL Template
-- Binary Counter

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity test_cmp4 is

	port
	(
		clk		  	: in std_logic;
		reset			: in std_logic;
	
		a				: out std_logic_vector(3 downto 0);
		b				: out std_logic_vector(3 downto 0);
		
		g				: in std_logic;
		l				: in std_logic;
		e				: in std_logic;
		
		ok				: out std_logic
	);

end entity;

architecture rtl of test_cmp4 is
	signal   cnt: integer range 0 to 255:=0;
	signal   cnt_next: integer range 0 to 255:=0;
	signal	a_out:std_logic_vector(3 downto 0):= (others=>'0');
	signal	b_out:std_logic_vector(3 downto 0):= (others=>'0');

	signal	ok_next: std_logic:='1';
	signal	ok_out: std_logic:='1';
	
	
begin

	process (clk)
	variable cnt_next:integer range 0 to 255;
	begin
	
	
	if (rising_edge(clk)) then
		if reset='1' then
			ok_out<='1';
			cnt<=0;
			cnt_next:=0;
		else
			cnt<=cnt_next;
			ok_out<=ok_out and ok_next;
			cnt_next:=cnt_next+1;
		end if;
	end if;
	end process;
	
	process (g,l,e,a_out,b_out) 
		variable res_g,res_e,res_l:std_logic;
	begin
	res_g:='0';
	res_l:='0';
	res_e:='0';
		if(unsigned(a_out)<unsigned(b_out)) then res_l:='1'; end if;
		if(unsigned(a_out)>unsigned(b_out)) then res_g:='1'; end if;
		if(unsigned(a_out)=unsigned(b_out)) then res_e:='1'; end if;
	if (res_g=g)and(res_l=l)and(res_e=e) then
			ok_next<='1';
			else
			ok_next<='0';
			end if;

	end process;
	
	a_out<=std_logic_vector(to_unsigned(cnt, 8))(3 downto 0);
	b_out<=std_logic_vector(to_unsigned(cnt, 8))(7 downto 4);
	
	
	a<=std_logic_vector(to_unsigned(cnt, 8))(3 downto 0);
	b<=std_logic_vector(to_unsigned(cnt, 8))(7 downto 4);
	
	ok<=ok_out;

end rtl;
